/****************************************************************************** 
 ** PIC USB Discriptor								Create Date	2015/12/03
 **			for PIC18 (Non-J Family)				Last Update	2016/03/03
 ** file name :  usbdesc.h									Saka Softwares
 ** language  :  XC8 (v1.35)
 ******************************************************************************
 ** HID Keyboard Demo 用です。
 ** USBの機能に合わせて変更が必要です。
 ******************************************************************************/
#ifndef _USB_DESCRIPTOR_H
#define	_USB_DESCRIPTOR_H
/** Include Files *************************************************************/
#include "usbconfig.h"

/******************************************************************************/
// スタンダード リクエスト
#define USB_MAX_DSC_CFG			1		// 設定するコンフィグ ディスクリプタ数
#define USB_MAX_DSC_INTF		1		// 設定するインターフェース ディスクリプタ数

// 各デスクプリタのサイズ
#define	DEVDSC_SIZE				0x12	// デバイス デスクプリタ
#define	CFGDSC_SIZE				0x09	// コンフィグ デスクプリタ
#define	IFDSC_SIZE				0x09	// インターフェース デスクプリタ
#define	HIDDSC_SIZE				0x09	// HID デスクプリタ
#define	EPDSC_SIZE				0x07	// エイドポイント デスクプリタ
#define	LANGDSC_SIZE			0x04	// 言語 ディスクリプタ

#define DSC_DEV					0x01	// デバイス ディスクプリタ タイプ
#define DSC_CFG					0x02	// コンフィグ ディスクプリタ タイプ
#define DSC_STR					0x03	// ストリング ディスクプリタ タイプ
#define DSC_INTF				0x04	// インターフェース ディスクプリタ タイプ
#define DSC_EP					0x05	// エンドポイント ディスクプリタ タイプ
#define DSC_DQ					0x06	// Device Qualitier
#define DSC_OSC					0x07	// Other Speed Configuratiln

#define DSC_EP_CTRL				0x00	// コントロール転送
#define DSC_EP_ISO				0x01	// アイソクロナス転送
#define DSC_EP_BULK				0x02	// バルク転送
#define DSC_EP_INT				0x03	// インターラプト転送

#define DSC_EP_IN				0x80	// エンドポイントIN
#define DSC_EP_OUT				0x00	// エンドポイントOUT

/******************************************************************************/
// クラスリクエスト (HID)
#define HID_INTF_ID				0
#define HID_NUM_OF_DSC			1		// クラスディスクリプタの数

// Class-Specific Requests
#define GET_REPORT				0x01
#define GET_IDLE				0x02
#define GET_PROTOCOL			0x03
#define SET_REPORT				0x09
#define SET_IDLE				0x0A
#define SET_PROTOCOL			0x0B

// Class Descriptor Types
#define DSC_HID					0x21
#define DSC_RPT					0x22
#define DSC_PHY					0x23

// Protocol Selection
#define BOOT_PROTOCOL			0x00
#define RPT_PROTOCOL			0x01

// HID Interface Class Code
#define HID_INTF				0x03

// HID Interface Class SubClass Codes
#define BOOT_INTF_SUBCLASS		0x01

// HID Interface Class Protocol Codes
#define HID_PROTOCOL_NONE		0x00
#define HID_PROTOCOL_KEYBOARD	0x01
#define HID_PROTOCOL_MOUSE 		0x02

// ディスクリプタ中のワード表記
#define DESC_WORD(a) (a&0xFF),((a>>8)&0xFF)

/******************************************************************************/
// ブート対応キーボード用 リポートディスクリプタ
const uint8_t hid_rpt01[]={
	0x05, 0x01,			// USAGE_PAGE (Generic Desktop)
	0x09, 0x06,			// USAGE (Keyboard)
	0xa1, 0x01,			// COLLECTION (Application)
	0x05, 0x07,			//   USAGE_PAGE (Keyboard)
	0x19, 0xe0,			//   USAGE_MINIMUM (Keyboard LeftControl)
	0x29, 0xe7,			//   USAGE_MAXIMUM (Keyboard Right GUI)
	0x15, 0x00,			//   LOGICAL_MINIMUM (0)
	0x25, 0x01,			//   LOGICAL_MAXIMUM (1)
	0x75, 0x01,			//   REPORT_SIZE (1)
	0x95, 0x08,			//   REPORT_COUNT (8)
	0x81, 0x02,			//   INPUT (Data,Var,Abs)
	0x95, 0x01,			//   REPORT_COUNT (1)
	0x75, 0x08,			//   REPORT_SIZE (8)
	0x81, 0x03,			//   INPUT (Cnst,Var,Abs)
	0x95, 0x05,			//   REPORT_COUNT (5)
	0x75, 0x01,			//   REPORT_SIZE (1)
	0x05, 0x08,			//   USAGE_PAGE (LEDs)
	0x19, 0x01,			//   USAGE_MINIMUM (Num Lock)
	0x29, 0x05,			//   USAGE_MAXIMUM (Kana)
	0x91, 0x02,			//   OUTPUT (Data,Var,Abs)
	0x95, 0x01,			//   REPORT_COUNT (1)
	0x75, 0x03,			//   REPORT_SIZE (3)
	0x91, 0x03,			//   OUTPUT (Cnst,Var,Abs)
	0x95, 0x06,			//   REPORT_COUNT (6)
	0x75, 0x08,			//   REPORT_SIZE (8)
	0x15, 0x00,			//   LOGICAL_MINIMUM (0)
	0x25, 0x65,			//   LOGICAL_MAXIMUM (101)
	0x05, 0x07,			//   USAGE_PAGE (Keyboard)
	0x19, 0x00,			//   USAGE_MINIMUM (Reserved (no event indicated))
	0x29, 0x65,			//   USAGE_MAXIMUM (Keyboard Application)
	0x81, 0x00,			//   INPUT (Data,Ary,Abs)
	0xc0				// End Collection
};    

/******************************************************************************/
// デバイスディスクリプタ
const uint8_t device_dsc[] = {
	DEVDSC_SIZE,					// ディスクリプタの長さ(0x12)
	DSC_DEV,						// ディスクリプタのタイプ (デバイス)
	DESC_WORD( 0x0200 ),			// BCD表現のUSB仕様リリース番号(Ver2.00)
	0x00,							// クラスコード
	0x00,							// サブクラスコード
	0x00,							// プロトコルコード
	EP0_BUFF_SIZE,					// EP0の最大パケットサイズ
	DESC_WORD( MY_VID ),			// ベンダー ID
	DESC_WORD( MY_PID ),			// プロダクト ID
	DESC_WORD( MY_RLS ),			// BCD表現のデバイスリリース番号
	0x01,							// 製造者名のインデックス
	0x02,							// 製品名のインデックス
	0x00,							// 製品番号名のインデックス
	USB_MAX_DSC_CFG					// 構成可能な数 (Configの数)
};

/******************************************************************************/
// 構成(コンフィグレーション)ディスクリプタ
const uint8_t cfg_dsc01[] = {
    // コンフィグレーション ディスクリプタ
	CFGDSC_SIZE,					// ディスクリプタの長さ(0x09)
	DSC_CFG,						// ディスクリプタのタイプ (構成)
	DESC_WORD(	CFGDSC_SIZE	+		// 構成全体(cofig, IF,etc)の長さ(可変)		
				IFDSC_SIZE	+
				HIDDSC_SIZE +		//(usbhiddrv.cは機能を制限している為、
				EPDSC_SIZE	+		// 構成全体を256Byte以内に設定してください。)
				EPDSC_SIZE	),
	USB_MAX_DSC_INTF,				// 構成が持つインターフェースの数
	1,								// この構成のインデックス番号(1以上)
	0,								// 構成名のインデックス
	CFG_ATTRIBUTES,					// 構成の特性 (ビット単位)
    50,								// 最大バス消費電流量 (2mA単位)

    // インターフェース ディスクリプタ
	IFDSC_SIZE,						// ディスクリプタの長さ(0x09)
	DSC_INTF,						// ディスクリプタのタイプ (インターフェース)
	HID_INTF_ID,					// インターフェース番号
	0,								// インターフェース代替え用番号
	2,								// IFが使用するEPの数
	HID_INTF,						// IFのクラスコード
	BOOT_INTF_SUBCLASS,				// IFサブクラスコード
	HID_PROTOCOL_KEYBOARD,			// IFのプロトコルコード
	0,								// IFのインデックス

	// HID クラス ディスクリプタ
	HIDDSC_SIZE,					// ディスクリプタの長さ(0x09)
	DSC_HID,						// ディスクリプタのタイプ (HID)
	DESC_WORD(0x0111),				// BCD表現のHIDバージョン (Ver1.11)
	0x00,							// 地域固有デバイスのための国識別番号
	HID_NUM_OF_DSC,					// クラスディスクリプタの数
	DSC_RPT,						// クラスディスクリプタの型
	DESC_WORD(sizeof(hid_rpt01)),	// レポートディスクリプタのサイズ
    
    // EP1 in ディスクリプタ
	EPDSC_SIZE,						// ディスクリプタの長さ(0x07)
	DSC_EP,							// ディスクリプタのタイプ (エンドポイント)
	DSC_EP_IN + 1,					// エンドポイント アドレス
	DSC_EP_INT,						// エンドポイントの属性
	DESC_WORD(EP1_IN_BUFF_SIZE),	// ペイロードサイズ
    1,								// データ通信間隔 (ms)

    // EP1 out ディスクリプタ
	EPDSC_SIZE,						// ディスクリプタの長さ(0x07)
	DSC_EP,							// ディスクリプタのタイプ (エンドポイント)
	DSC_EP_OUT + 1,					// エンドポイント アドレス
	DSC_EP_INT,						// エンドポイントの属性
	DESC_WORD(EP1_OUT_BUFF_SIZE),	// ペイロードサイズ
    1,								// データ通信間隔 (ms)
};

/******************************************************************************/
// 言語コード名 ディスクリプタ
const struct{uint8_t bLength;uint8_t bDscType;uint16_t string[1];}sd000={
	sizeof(sd000), DSC_STR, { 0x0409 }
};

/******************************************************************************/
// 製造者名 ディスクリプタ
const struct{uint8_t bLength;uint8_t bDscType;uint16_t string[25];}sd001={
	sizeof(sd001), DSC_STR,
	{'M','i','c','r','o','c','h','i','p',' ',
	 'T','e','c','h','n','o','l','o','g','y',' ','I','n','c','.'}
};

/******************************************************************************/
// 製品名 ディスクリプタ
const struct{uint8_t bLength;uint8_t bDscType;uint16_t string[13];}sd002={
	sizeof(sd002), DSC_STR,
	{'K','e','y','b','o','a','r','d',' ','D','e','m','o'}
};	

/******************************************************************************/
// 各名称ディスクリプタインデックス
const uint8_t *const USB_SD_Ptr[]={
	(const uint8_t *const)&sd000,
	(const uint8_t *const)&sd001,
	(const uint8_t *const)&sd002,
};

#endif	//_USB_DESCRIPTOR_H
